<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section2
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                   
#  Last update : 10/10/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="*[@FORM][.//ted:NOTICE[@TYPE!='PRI_ONLY' and @TYPE!='PER_ONLY']][count(ted:OBJECT_CONTRACT)>1]" mode="R314R315">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ted:NOTICE/@*,' and number(OBJECT_CONTRACT)=',count(./ted:OBJECT_CONTRACT))"/>
		<xsl:choose>
			<xsl:when test="@FORM='F01' or @FORM='F21'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R314'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@FORM='F04' or @FORM='F22'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R315'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][.//ted:DIRECTIVE/@*='2014/23/EU' and .//ted:TYPE_CONTRACT/@*='SUPPLIES']" mode="R316">
		<xsl:variable name="ele" select="concat('DIRECTIVE/@VALUE=', .//ted:DIRECTIVE/@*,' and TYPE_CONTRACT/@CTYPE=',.//ted:TYPE_CONTRACT/@*)"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R316'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']]//ted:OBJECT_CONTRACT[1]/ted:SHORT_DESCR" mode="R317">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R317'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]/ted:VAL_ESTIMATED_TOTAL" mode="R318R319">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='AWARD_CONTRACT' and @TYPE!='QSU_ONLY' and @TYPE!='QSU_CALL_COMPETITION'] "/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R318'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='QSU_ONLY' or @TYPE='QSU_CALL_COMPETITION']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R319'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']]//ted:OBJECT_CONTRACT[1]/ted:LOT_DIVISION" mode="R320">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R320'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:LOT_ALL|ted:LOT_MAX_NUMBER|ted:LOT_ONE_ONLY" mode="R321R322R324">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F01' and @FORM!='F04' and @FORM!='F21' and @FORM!='F22' and @FORM!='F23']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='PRI_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R321'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='PER_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R322'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='CONCESSION_AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R324'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]//ted:LOT_ALL|ted:OBJECT_CONTRACT[1]//ted:LOT_MAX_NUMBER|ted:OBJECT_CONTRACT[1]//ted:LOT_ONE_ONLY" mode="R323">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='AWARD_CONTRACT']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R323'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]//ted:LOT_MAX_ONE_TENDERER" mode="R325R326">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22' and @FORM!='F23']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='AWARD_CONTRACT' and @TYPE!='CONCESSION_AWARD_CONTRACT']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R325'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='CONCESSION_AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R326'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]//ted:LOT_COMBINING_CONTRACT_RIGHT" mode="R327R328">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22' and @FORM!='F23']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE!='AWARD_CONTRACT' and @TYPE!='CONCESSION_AWARD_CONTRACT']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R327'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='CONCESSION_AWARD_CONTRACT']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R328'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT/ted:VAL_TOTAL|ted:OBJECT_CONTRACT/ted:VAL_RANGE_TOTAL" mode="R329">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22' and @FORM!='F23']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@TYPE='AWARD_CONTRACT' or @TYPE='CONCESSION_AWARD_CONTRACT']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R329'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F03' or @FORM='F06' or @FORM='F25'] |*[@FORM][ted:NOTICE/@*[matches(.,'AWARD')]]" mode="R331R332">
		<xsl:variable name="ele1" select="'AWARDED_CONTRACT and missing OBJECT_CONTRACT[1]/VAL_(RANGE_)TOTAL'"/>
		<xsl:variable name="ele2" select="'OBJECT_CONTRACT[1]/VAL_(RANGE_)TOTAL'"/>
		<xsl:choose>
			<xsl:when test=".//ted:AWARDED_CONTRACT and .//ted:OBJECT_CONTRACT[1][not(ted:VAL_TOTAL or ted:VAL_RANGE_TOTAL)]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R332'"/>
					<xsl:with-param name="content" select="$ele1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="not(.//ted:AWARDED_CONTRACT) and .//ted:OBJECT_CONTRACT[1][ted:VAL_TOTAL or ted:VAL_RANGE_TOTAL]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R331'"/>
					<xsl:with-param name="content" select="$ele2"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][.//ted:NOTICE[@TYPE='QSU_ONLY' or @TYPE='QSU_CALL_COMPETITION']][count(.//ted:OBJECT_CONTRACT[1]/ted:OBJECT_DESCR)>1]" mode="R333">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and number(OBJECT_DESCR)=', count(.//ted:OBJECT_CONTRACT[1]/ted:OBJECT_DESCR))"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R333'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_DESCR[parent::*//ted:LOT_DIVISION][not(.//ted:CPV_ADDITIONAL)]" mode="R334">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'P.._ONLY'))] and parent::ted:OBJECT_CONTRACT/@ITEM>1"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',parent::*/@ITEM,']/LOT_DIVISION and missing OBJECT_DESCR[',@ITEM,']/CPV_ADDITIONAL')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R334'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_DESCR[ancestor::*[@FORM]//ted:NOTICE[@TYPE='PRI_ONLY' or @TYPE='PER_ONLY']]/ted:*[matches(local-name(),'^AC_')]" mode="R335R336">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*/@FORM='F01'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R335'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*/@FORM='F04'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R336'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[*[matches(local-name(),'^AC_')]][ancestor::*[@FORM='F15']]" mode="R337">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:DIRECTIVE/@*='2014/23/EU' and local-name()='DIRECTIVE_2014_23_EU'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:DIRECTIVE/@*='2014/24/EU' and local-name()='DIRECTIVE_2014_24_EU'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:DIRECTIVE/@*='2014/25/EU' and local-name()='DIRECTIVE_2014_25_EU'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:DIRECTIVE/@*='2009/81/EC' and local-name()='DIRECTIVE_2009_81_EC'"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('DIRECTVE/@VALUE=', ancestor::*[@FORM]//ted:DIRECTIVE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/', local-name())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R337'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:VAL_OBJECT[ancestor::*[@FORM]//ted:NOTICE]" mode="R338R339R340R342">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R338'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R339'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R340'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='CONCESSION_AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R342'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22']//ted:OBJECT_CONTRACT[1]//ted:OBJECT_DESCR[1]/ted:VAL_OBJECT" mode="R341">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*!='QSU_ONLY' and @*!='QSU_CALL_COMPETITION']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R341'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DURATION|ted:DATE_START|ted:DATE_END" mode="R343R344R345R346">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F07'] or parent::ted:QS"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY' and ancestor::*[@FORM='F01']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R343'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY' and ancestor::*[@FORM='F04']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R344'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY' and ancestor::*[@FORM='F21']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R345'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY' and ancestor::*[@FORM='F22'] ">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R346'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]//ted:OBJECT_DESCR[1]//*[self::ted:DURATION|self::ted:DATE_START|self::ted:DATE_END]" mode="R347">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F07'] or parent::ted:QS"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R347'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[1]//*[self::ted:DURATION|self::ted:DATE_START|self::ted:DATE_END]" mode="R348">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F07'] or parent::ted:QS"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R348'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][ted:NOTICE[@TYPE='CONCESSION_AWARD_CONTRACT']]//ted:OBJECT_DESCR" mode="R349">
		<xsl:if test="not(ted:DURATION|ted:DATE_START|ted:DATE_END)">
			<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and missing {DURATION, DATE_START, DATE_END} (OBJECT_DESCR[',@ITEM,'])')"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R349'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][ted:NOTICE[@*!='PER_ONLY' and @*!='QSU_ONLY' and @*!='QSU_CALL_COMPETITION']]//ted:OBJECT_CONTRACT[1]//ted:QS/child::*" mode="R350">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',ancestor::ted:OBJECT_DESCR/@ITEM,']/QS/',local-name())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R350'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="*[@FORM='F22'][ted:NOTICE[@*='PER_ONLY']]//ted:QS/child::*" mode="R350">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',ancestor::ted:OBJECT_DESCR/@ITEM,']/QS/',local-name())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R350'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']]//ted:OBJECT_CONTRACT[1]//ted:OBJECT_DESCR[1]" mode="R351">
		<xsl:if test="not(ted:QS)">
			<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and missing {QS/DURATION, QS/DATE_START, QS/DATE_END} (OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',@ITEM,'])')"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R351'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05'][.//ted:PT_OPEN]//ted:*[matches(local-name(),'CANDIDATE$')]" mode="R352">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('PT_OPEN and OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R352'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04'][ted:NOTICE[@*='PRI_ONLY' or @*='PER_ONLY']]//ted:ACCEPTED_VARIANTS" mode="R353R354">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R353'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R354'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04'][ted:NOTICE[@*='PRI_ONLY' or @*='PER_ONLY']]//ted:*[matches(local-name(),'^OPTIONS')]" mode="R355R356">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R355'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R356'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21'][ted:NOTICE[@*='PRI_ONLY' or @*='PER_ONLY']]//ted:*[matches(local-name(),'EU_PROGR')]" mode="R357R358">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',parent::*/@ITEM,']/',local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F01' or @FORM='F21']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R357'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM='F04']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R358'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21']//ted:OBJECT_CONTRACT[1]//ted:OBJECT_DESCR[not(.//ted:*[matches(local-name(),'EU_PROGR')])]" mode="R359R360R361">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and missing (NO_)EU_PROGR_RELATED (OBJECT_CONTRACT[',parent::ted:OBJECT_CONTRACT/@ITEM,']/OBJECT_DESCR[',@ITEM,'])')"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'REDUCING_TIME_LIMITS')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R359'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'CALL_COMPETITION')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R360'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='AWARD_CONTRACT']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R361'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21' or @FORM='F22']//ted:OBJECT_CONTRACT[1]//ted:DATE_PUBLICATION_NOTICE" mode="R362R363R364">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and OBJECT_CONTRACT[1]/', local-name())"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'QSU')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R364'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'CALL_COMPETITION')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R362'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R362'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='AWARD_CONTRACT']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R363'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21' or @FORM='F22'][ted:NOTICE[@*='PRI_ONLY' or @*='PER_ONLY']]//ted:OBJECT_CONTRACT[not(.//ted:DATE_PUBLICATION_NOTICE)]" mode="R365R366">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and missing DATE_PUBLICATION_NOTICE')"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R365'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R366'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04']//ted:OBJECT_CONTRACT[1][not(.//ted:DATE_PUBLICATION_NOTICE)]" mode="R367">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'REDUCING_TIME_LIMITS'))]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and missing DATE_PUBLICATION_NOTICE')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R367'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[ted:NO_LOT_DIVISION]/ted:OBJECT_DESCR/*[ self::ted:TITLE|self::ted:LOT_NO ]" mode="R368">
		<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/NO_LOT_DIVISION and OBJECT_DESCR[',parent::*/@ITEM,']/', local-name())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R368'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[ted:LOT_DIVISION]/ted:OBJECT_DESCR[ not(ted:LOT_NO) ]" mode="R369">
		<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',ancestor::ted:OBJECT_CONTRACT/@ITEM,']/LOT_DIVISION and missing OBJECT_DESCR[',@ITEM,']/LOT_NO')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R369'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[ted:SHORT_DESCR]" mode="R370">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'P.._ONLY'))] and @ITEM>1"/>
			<xsl:when test="ted:SHORT_DESCR[descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',@ITEM,']/SHORT_DESCR')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R370'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_DESCR[ted:SHORT_DESCR]" mode="R371">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION'] and @ITEM>1"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'P.._ONLY'))] and parent::ted:OBJECT_CONTRACT/@ITEM>1"/>
			<xsl:when test="ted:SHORT_DESCR[descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',parent::*/@ITEM,']/OBJECT_DESCR[',@ITEM,']/SHORT_DESCR')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R371'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[.//ted:LOT_COMBINING_CONTRACT_RIGHT]" mode="R372">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'QSU|AWARD_CONTRACT')] "/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'P.._ONLY'))] and @ITEM>1"/>
			<xsl:when test=".//ted:LOT_COMBINING_CONTRACT_RIGHT/descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',@ITEM,']/LOT_COMBINING_CONTRACT_RIGHT empty')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R372'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_DESCR[.//ted:AC_PRICE/ted:AC_WEIGHTING and not(.//ted:AC_QUALITY)]" mode="R373">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'P.._ONLY')] "/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[not(matches(.,'P.._ONLY'))] and parent::ted:OBJECT_CONTRACT/@ITEM>1"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',parent::*/@ITEM,']/OBJECT_DESCR[',@ITEM,']/AC_PRICE/AC_WEIGHTING')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R373'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05']//ted:OBJECT_DESCR[.//ted:RENEWAL_DESCR]" mode="R374">
		<xsl:choose>
			<xsl:when test=".//ted:RENEWAL_DESCR/descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_DESCR[',@ITEM,']/RENEWAL_DESCR empty')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R374'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_DESCR[.//ted:OPTIONS_DESCR]" mode="R375">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F01' or @FORM='F04' ]"/>
			<xsl:when test=".//ted:OPTIONS_DESCR/descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_DESCR[',@ITEM,']/OPTIONS_DESCR empty')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R375'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:TITLE[ parent::ted:OBJECT_CONTRACT]" mode="R376">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',parent::ted:OBJECT_CONTRACT/@ITEM,']/TITLE')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R376'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:OBJECT_CONTRACT[.//ted:LOT_DIVISION][count(.//ted:OBJECT_DESCR) != count(distinct-values(.//ted:LOT_NO/normalize-space()))]" mode="R377">
		<xsl:choose>
			<xsl:when test=".//ted:OBJECT_DESCR[not(ted:LOT_NO)]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT[',@ITEM,'][Total LOT_NO: ',count(.//ted:OBJECT_DESCR),' / Unique LOT_NO: ',count(distinct-values(.//ted:LOT_NO/normalize-space())),']')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R377'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<!--<xsl:template match="ted:OBJECT_CONTRACT[.//ted:LOT_MAX_NUMBER][number(.//ted:LOT_MAX_NUMBER) !=count(.//ted:OBJECT_DESCR)]" mode="R378">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'AWARD'|'QSU'|'PRI_ONLY'|'PER_ONLY')]"/>
			<xsl:when test="count(ancestor::*[@FORM]//ted:OBJECT_CONTRACT)>1"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('OBJECT_CONTRACT [Total LOT_NO: ',count(.//ted:OBJECT_DESCR),' / LOT_MAX_NUMBER: ',.//ted:LOT_MAX_NUMBER,']')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R378'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>-->
</xsl:stylesheet>
